# 🎬 Video Stabilizer - Local Mac Setup (v4 - Deshake Edition)

## ✨ What's New in v4

**No more vidstab headaches!** This version uses FFmpeg's **built-in deshake filter** which:
- ✅ Works with ANY FFmpeg installation
- ✅ No special compilation needed
- ✅ Simpler, more reliable
- ✅ Still produces great stabilization results

## What is this?

This is a **local video stabilizer** that runs on your Mac. Your videos never leave your computer - everything is processed locally using FFmpeg.

## Features

✅ Remove camera shake and jitter  
✅ Device-specific presets (Phone, GoPro, Drone)  
✅ Jello effect reduction  
✅ Denoise & sharpen options  
✅ Up to 8 seconds of free stabilization  
✅ 4K export with audio preservation  

---

## 🚀 Quick Start (3 Simple Steps)

### ⚠️ IMPORTANT: Extract to Downloads Folder

**Before starting, extract this package to your Downloads folder:**

```
~/Downloads/stabilizer-package-v4/
```

---

### Step 1: Run Setup (ONE TIME ONLY)

**Right-click** on **`setup.command`** → Select **"Open"**

⚠️ **Mac Security Warning - This is NORMAL!**
- Mac will show: *"Apple could not verify 'setup.command' is free of malware..."*
- Click **"Open"** to continue
- Enter your **Mac password** when prompted

**What it installs:**
- Homebrew (Mac package manager)
- Node.js (JavaScript runtime)
- FFmpeg (Video processing - ANY version works!)
- npm packages (dependencies)

⏱️ Takes 5-10 minutes depending on internet speed.

---

### Step 2: Start the Server (Every Time)

**Right-click** on **`start.command`** → Select **"Open"**

- Keep the terminal window **OPEN** while stabilizing
- Server runs at `http://localhost:3000`
- Press `Ctrl+C` to stop when done

---

### Step 3: Use the Web Interface

Go to: **https://confidentcinematiclab.com/video_stabilizer.html**

The page will automatically detect your local server!

---

## 🔧 Troubleshooting

### "Apple could not verify setup.command"

**This is NORMAL!** Every Mac user sees this for downloaded scripts.

**Fix:**
1. **Right-click** on `setup.command`
2. Choose **"Open"** from menu
3. Click **"Open"** in the popup

---

### npm Install Errors (Permission Denied, EACCES, etc.)

If setup.command fails with npm errors, run this manually:

```bash
cd ~/Downloads/stabilizer-package-v4
sudo npm install --unsafe-perm
```

Enter your Mac password when prompted.

---

### "FFmpeg not found" or "Command not found: ffmpeg"

Run setup.command again, or install manually:

```bash
brew install ffmpeg
```

---

### Server Won't Start

1. Make sure you ran `setup.command` first
2. Check if port 3000 is in use:
   ```bash
   lsof -i :3000
   ```
3. Kill any process on port 3000:
   ```bash
   lsof -ti:3000 | xargs kill -9
   ```

---

## 📁 Package Contents

- **setup.command** - One-time installer
- **start.command** - Start the server
- **server.js** - Stabilizer backend (using deshake filter)
- **package.json** - Dependencies list
- **README.md** - This file

---

## 🛡️ Privacy & Security

✅ All processing happens **locally on your Mac**  
✅ Videos are **never uploaded to the internet**  
✅ Temporary files **auto-delete after 30 minutes**  
✅ Scripts are **open source** - read them in TextEdit!

**Mac's security warning is just standard caution for downloaded files.**

---

## 💡 Daily Use Workflow

After initial setup:

1. **Right-click `start.command`** → Open
2. **Go to website** and upload video
3. **Wait** for processing (1-2 minutes)
4. **Download** stabilized video
5. **Press Ctrl+C** in terminal to stop server

---

## 🔄 Folder Structure After Setup

```
stabilizer-package-v4/
├── setup.command          (run once)
├── start.command          (run each time)
├── server.js              (backend code)
├── package.json           (dependencies)
├── README.md              (this file)
├── node_modules/          (created by setup)
├── uploads/               (temp input files)
├── outputs/               (stabilized videos)
└── temp/                  (processing files)
```

Files in `uploads/`, `outputs/`, and `temp/` auto-delete after 30 minutes.

---

## ❓ Common Questions

**Q: Why extract to Downloads folder?**  
A: The scripts use `~/Downloads/stabilizer-package-v4` as the default path. You can put it elsewhere, but you'll need to adjust commands.

**Q: Why does it need my password?**  
A: npm needs admin access to install packages. This is standard for Mac development tools.

**Q: Do my videos get uploaded?**  
A: No! Everything runs locally. Videos never leave your Mac.

**Q: Can I use this on Windows?**  
A: Not yet. Windows support coming soon!

**Q: Is this different from the previous version?**  
A: Yes! v4 uses FFmpeg's built-in `deshake` filter instead of the problematic `vidstab` filters. This means:
- Works with ANY FFmpeg installation
- No special compilation needed
- Much simpler setup
- Still produces excellent results

**Q: Will the quality be different?**  
A: The deshake filter is slightly different from vidstab, but it still produces excellent stabilization results for most use cases.

---

## 📧 Need Help?

Email: support@confidentcinematiclab.com

Include:
- macOS version
- Node.js version (`node --version`)
- npm version (`npm --version`)
- Full error message from Terminal

---

## 🎯 Summary

**For first-time setup:**
1. Extract to `~/Downloads/stabilizer-package-v4`
2. Right-click `setup.command` → Open
3. Enter password when prompted
4. Wait for installation

**If npm errors occur:**
```bash
cd ~/Downloads/stabilizer-package-v4
sudo npm install --unsafe-perm
```

**To use after setup:**
1. Right-click `start.command` → Open
2. Go to website
3. Stabilize videos!

---

**Made with ❤️ by Cinematic Lab**

**Version 4.0** - January 2026 - Deshake Edition
